//**************************************************************
//	Copyright (C) 2010-2011 by L-1 Identity Solutions
// Name:         TPAPI.NetSampleApp.cs
// Description:  TPAPI .NET Sample Application
//**************************************************************
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Threading;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Reflection;
using System.IO;

#if USE_USBHIDIO
using HIDIOWINCS;
#endif
using TPAPI.NetWrapper;

namespace TPAPI.NetSampleApp
{
   /// <summary>
	/// Summary description for MainForm.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
      private const int LED_NONE = 0;
      private const int LED_LEFT = 1;
      private const int LED_MID = 2;
      private const int LED_RIGHT = 3;
      private const int BANDED_LINES = 4;
      private const String strAppName = "TPAPI .NET Sample Application";
      private CheckBox ChkRT;
      private CheckBox ChkRI;
      private CheckBox ChkRM;
      private CheckBox ChkRR;
      private CheckBox ChkRL;
      private CheckBox ChkLT;
      private CheckBox ChkLI;
      private CheckBox ChkLM;
      private CheckBox ChkLR;
      private CheckBox ChkLL;
      private CheckBox ChkDFC;
      private CheckBox chkPollDev;

      public class cTypeInfo
      {
         public cTypeInfo(TpApiDevice.eCaptureType ctype, int LED)
         { base_ctype = ctype; statusLED = LED;  }
         public TpApiDevice.eCaptureType base_ctype;
         public int statusLED;
      };
      private cTypeInfo[] capTypeInfo = new cTypeInfo[21] {
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_NONE), 
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_ONE,      LED_NONE),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR,     LED_NONE),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_HAND,          LED_NONE),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR,     LED_LEFT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR,     LED_RIGHT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR,     LED_MID),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_ONE,      LED_MID),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_ONE,      LED_MID),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_MID),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_LEFT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_LEFT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_LEFT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_LEFT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_MID),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_RIGHT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_RIGHT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_RIGHT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_ROLL,          LED_RIGHT),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_PALM,     LED_NONE),
         new cTypeInfo(TpApiDevice.eCaptureType.CTYPE_SLAP_PALM,     LED_NONE)
      };

      public class AdvancedCursors
      {
         [DllImport("User32.dll")]
         static extern IntPtr CreateIconFromResource(byte[] presbits, uint dwResSize,
            bool fIcon, uint dwVer);

         public static Cursor Create(byte[] advCur)
         {
            try
            {
               IntPtr hCursor = CreateIconFromResource(advCur, (uint)advCur.GetLength(0), false, 0x00030000);
               if (!IntPtr.Zero.Equals(hCursor))
                  return new Cursor(hCursor);
               else
                  throw new ApplicationException("Could not create cursor");
            } catch(Exception) {
               return Cursor.Current;
            }
         }
      }

      private void ReadWriteStream(Stream readStream, Stream writeStream)
      {
         int Length = 256;
         Byte[] buffer = new Byte[Length];
         int bytesRead = readStream.Read(buffer, 0, Length);
         // write the required bytes
         while (bytesRead > 0)
         {
            writeStream.Write(buffer, 0, bytesRead);
            bytesRead = readStream.Read(buffer, 0, Length);
         }
         readStream.Close();
         writeStream.Close();
      }

      /// <summary>
		/// Device Info
		/// </summary>
		private struct DeviceInfo
		{
			/// <summary>
			/// Make: i.e. "IDX"
			/// </summary>
			public string Make;
			/// <summary>
			/// Model: i.e. "TP-4100U"
			/// </summary>
			public string Model;
			/// <summary>
			/// SN: i.e "123456789"
			/// </summary>
			public string SN;
			/// <summary>
			/// Version: i.e. "1.15"
			/// </summary>
			public string Version;
		}

      //---------------------------------------------------
      //                   Properties
      //---------------------------------------------------
      private TpApi cTpApi = new TpApi();
      private TpApiDevice[] m_tpDevices;     // All Available Devices
      private TpApiDevice m_Device;          // Selected Device
      private float m_capRes = 500F;
      private TpApiDevice.eCaptureType m_capType, m_capTypeSave;
      private System.Drawing.Image m_capTypeImg;
      private TpApiDevice.eCaptureType m_baseType;
      private TpApiDevice.eCaptureState m_capState;
      private TpApiDevice.s_imgQA m_quality = new TpApiDevice.s_imgQA();
      private DeviceInfo m_devInfo; 
      private bool m_initialized = false;
      private bool m_Connected = false;
      private bool m_bChkRollEnabled = false;
      private bool m_bChkAutoCapEnabled = true;
      private bool m_bChkAutoCapChecked = true;
      private bool m_bCaptureInProgress = false;
      private ushort m_xsize;
      private ushort m_ysize;
      private byte[] m_imageBuf;
      private byte[] finishedImageBuf;
      private ushort finishedXsize;
      private ushort finishedYsize;
      private Cursor aniCursor = null;
      private Rectangle m_imgArea;
#if USE_USBHIDIO
      private DelcomHID m_FootSw = new DelcomHID();
      private System.Windows.Forms.Timer tmrChkFsw;
#endif
#if DISPLAY_FPS
      private DateTime startTime;
      private DateTime curTime;
      private int numFrms;
      private Label LblFPS;
#endif


      private delegate void PreviewInvokeDelegate();
      private PreviewInvokeDelegate PreviewMethod;
      private System.Windows.Forms.PictureBox ImageBox;
      private System.Windows.Forms.Button BtnStartCapture;
      private System.Windows.Forms.Button BtnStopCapture;
      private System.Windows.Forms.Button BtnCalPlaten;
      private System.Windows.Forms.Button BtnCalDrum;
      private Label CoverPct;
      private Label TimeMs;
      private Label ContactPct;
      private Label GoodPct;
      private Label DarkPct;
      private Label SmearPct;
      private ComboBox ComboDevSel;
      private Label LblStatus;
      private CheckBox ChkRTQA;
      private Button BtnSaveAs;
      private Button BtnExit;
      private CheckBox ChkAutoCap;
      private RadioButton Radio500;
      private RadioButton Radio1000;
      private Label LightPct;
      private Label LblTime;
      private Label LblCover;
      private CheckBox ChkRoll;
      private RadioButton RadioL4;
      private RadioButton RadioRR;
      private RadioButton RadioRM;
      private RadioButton RadioR4;
      private RadioButton RadioLP;
      private RadioButton RadioRI;
      private RadioButton RadioRT;
      private RadioButton RadioRL;
      private RadioButton RadioLL;
      private RadioButton RadioLT;
      private RadioButton RadioLR;
      private RadioButton RadioLM;
      private RadioButton RadioLH;
      private RadioButton RadioLI;
      private RadioButton Radio2T;
      private RadioButton RadioRP;
      private RadioButton RadioRH;
      private PictureBox PicBoxCapType;
      private GroupBox GrpBoxCapMode;
      private Label LblRes;
      private System.Windows.Forms.Timer tmrChkDev;
      private PictureBox idxLogo;
      private Label LblPrompt;
      //private TransparentLabel LblPrompt;
      private IContainer components;

		Graphics imageGraphic;

      public MainForm()
      {  //
         // Required for Windows Form Designer support
         //
         InitializeComponent();

#if DISPLAY_FPS
         LblFPS = new System.Windows.Forms.Label();
         LblFPS.AutoSize = true;
         LblFPS.Location = new System.Drawing.Point(64, 725);
         LblFPS.Name = "LblFPS";
         LblFPS.Size = new System.Drawing.Size(30, 13);
         LblFPS.Text = "0 fps";
         LblFPS.Visible = false;
         Controls.Add(LblFPS);
#endif
         PreviewMethod = new PreviewInvokeDelegate(PreviewInvoke);
         m_initialized = false;
         imageGraphic = ImageBox.CreateGraphics();
         greyPalette();
         speedPalette();
         decoratedPalette();
         m_imgArea = ImageBox.Bounds;
      }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if (disposing)
			{
				if (components != null) 
					components.Dispose();
			}
         this.tmrChkDev.Stop();
#if USE_USBHIDIO
         this.tmrChkFsw.Stop();
         this.m_FootSw.Close();
#endif
         base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
         this.components = new System.ComponentModel.Container();
         System.Windows.Forms.Label LblLight;
         System.Windows.Forms.Label LblDark;
         System.Windows.Forms.Label LblGood;
         System.Windows.Forms.Label LblContact;
         System.Windows.Forms.GroupBox GrpBoxCal;
         System.Windows.Forms.Label LblSmear;
         System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainForm));
         this.BtnCalPlaten = new System.Windows.Forms.Button();
         this.BtnCalDrum = new System.Windows.Forms.Button();
         this.GrpBoxCapMode = new System.Windows.Forms.GroupBox();
         this.SmearPct = new System.Windows.Forms.Label();
         this.ChkAutoCap = new System.Windows.Forms.CheckBox();
         this.ChkRTQA = new System.Windows.Forms.CheckBox();
         this.LightPct = new System.Windows.Forms.Label();
         this.DarkPct = new System.Windows.Forms.Label();
         this.GoodPct = new System.Windows.Forms.Label();
         this.ContactPct = new System.Windows.Forms.Label();
         this.TimeMs = new System.Windows.Forms.Label();
         this.CoverPct = new System.Windows.Forms.Label();
         this.LblTime = new System.Windows.Forms.Label();
         this.LblCover = new System.Windows.Forms.Label();
         this.LblRes = new System.Windows.Forms.Label();
         this.Radio1000 = new System.Windows.Forms.RadioButton();
         this.Radio500 = new System.Windows.Forms.RadioButton();
         this.BtnStartCapture = new System.Windows.Forms.Button();
         this.BtnStopCapture = new System.Windows.Forms.Button();
         this.ComboDevSel = new System.Windows.Forms.ComboBox();
         this.LblStatus = new System.Windows.Forms.Label();
         this.BtnSaveAs = new System.Windows.Forms.Button();
         this.BtnExit = new System.Windows.Forms.Button();
         this.ChkRoll = new System.Windows.Forms.CheckBox();
         this.RadioL4 = new System.Windows.Forms.RadioButton();
         this.RadioLT = new System.Windows.Forms.RadioButton();
         this.RadioLI = new System.Windows.Forms.RadioButton();
         this.RadioLM = new System.Windows.Forms.RadioButton();
         this.RadioLR = new System.Windows.Forms.RadioButton();
         this.RadioLL = new System.Windows.Forms.RadioButton();
         this.RadioR4 = new System.Windows.Forms.RadioButton();
         this.RadioRT = new System.Windows.Forms.RadioButton();
         this.RadioRI = new System.Windows.Forms.RadioButton();
         this.RadioRM = new System.Windows.Forms.RadioButton();
         this.RadioRR = new System.Windows.Forms.RadioButton();
         this.RadioRL = new System.Windows.Forms.RadioButton();
         this.Radio2T = new System.Windows.Forms.RadioButton();
         this.RadioLH = new System.Windows.Forms.RadioButton();
         this.RadioRH = new System.Windows.Forms.RadioButton();
         this.RadioLP = new System.Windows.Forms.RadioButton();
         this.RadioRP = new System.Windows.Forms.RadioButton();
         this.tmrChkDev = new System.Windows.Forms.Timer(this.components);
         this.idxLogo = new System.Windows.Forms.PictureBox();
         this.PicBoxCapType = new System.Windows.Forms.PictureBox();
         this.ImageBox = new System.Windows.Forms.PictureBox();
         this.LblPrompt = new System.Windows.Forms.Label();
         this.ChkRT = new System.Windows.Forms.CheckBox();
         this.ChkRI = new System.Windows.Forms.CheckBox();
         this.ChkRM = new System.Windows.Forms.CheckBox();
         this.ChkRR = new System.Windows.Forms.CheckBox();
         this.ChkRL = new System.Windows.Forms.CheckBox();
         this.ChkLT = new System.Windows.Forms.CheckBox();
         this.ChkLI = new System.Windows.Forms.CheckBox();
         this.ChkLM = new System.Windows.Forms.CheckBox();
         this.ChkLR = new System.Windows.Forms.CheckBox();
         this.ChkLL = new System.Windows.Forms.CheckBox();
         this.ChkDFC = new System.Windows.Forms.CheckBox();
         this.chkPollDev = new System.Windows.Forms.CheckBox();
         LblLight = new System.Windows.Forms.Label();
         LblDark = new System.Windows.Forms.Label();
         LblGood = new System.Windows.Forms.Label();
         LblContact = new System.Windows.Forms.Label();
         GrpBoxCal = new System.Windows.Forms.GroupBox();
         LblSmear = new System.Windows.Forms.Label();
         GrpBoxCal.SuspendLayout();
         this.GrpBoxCapMode.SuspendLayout();
         ((System.ComponentModel.ISupportInitialize)(this.idxLogo)).BeginInit();
         ((System.ComponentModel.ISupportInitialize)(this.PicBoxCapType)).BeginInit();
         ((System.ComponentModel.ISupportInitialize)(this.ImageBox)).BeginInit();
         this.SuspendLayout();
         // 
         // LblLight
         // 
         LblLight.Location = new System.Drawing.Point(37, 108);
         LblLight.Name = "LblLight";
         LblLight.Size = new System.Drawing.Size(58, 14);
         LblLight.TabIndex = 5;
         LblLight.Text = "Light:";
         LblLight.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         // 
         // LblDark
         // 
         LblDark.Location = new System.Drawing.Point(37, 94);
         LblDark.Name = "LblDark";
         LblDark.Size = new System.Drawing.Size(58, 14);
         LblDark.TabIndex = 4;
         LblDark.Text = "Dark:";
         LblDark.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         // 
         // LblGood
         // 
         LblGood.Location = new System.Drawing.Point(37, 74);
         LblGood.Name = "LblGood";
         LblGood.Size = new System.Drawing.Size(58, 16);
         LblGood.TabIndex = 3;
         LblGood.Text = "Good:";
         LblGood.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         // 
         // LblContact
         // 
         LblContact.AutoSize = true;
         LblContact.Location = new System.Drawing.Point(37, 58);
         LblContact.Name = "LblContact";
         LblContact.Size = new System.Drawing.Size(58, 13);
         LblContact.TabIndex = 2;
         LblContact.Text = "% Contact:";
         LblContact.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         // 
         // GrpBoxCal
         // 
         GrpBoxCal.Controls.Add(this.BtnCalPlaten);
         GrpBoxCal.Controls.Add(this.BtnCalDrum);
         GrpBoxCal.Location = new System.Drawing.Point(16, 664);
         GrpBoxCal.Name = "GrpBoxCal";
         GrpBoxCal.Size = new System.Drawing.Size(153, 57);
         GrpBoxCal.TabIndex = 22;
         GrpBoxCal.TabStop = false;
         GrpBoxCal.Text = "Calibrate";
         // 
         // BtnCalPlaten
         // 
         this.BtnCalPlaten.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.BtnCalPlaten.Location = new System.Drawing.Point(11, 20);
         this.BtnCalPlaten.Name = "BtnCalPlaten";
         this.BtnCalPlaten.Size = new System.Drawing.Size(60, 26);
         this.BtnCalPlaten.TabIndex = 7;
         this.BtnCalPlaten.Text = "Platen";
         this.BtnCalPlaten.Click += new System.EventHandler(this.CalPlaten_Click);
         // 
         // BtnCalDrum
         // 
         this.BtnCalDrum.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.BtnCalDrum.Location = new System.Drawing.Point(81, 20);
         this.BtnCalDrum.Name = "BtnCalDrum";
         this.BtnCalDrum.Size = new System.Drawing.Size(60, 26);
         this.BtnCalDrum.TabIndex = 8;
         this.BtnCalDrum.Text = "Drum";
         this.BtnCalDrum.Click += new System.EventHandler(this.CalHand_Click);
         // 
         // LblSmear
         // 
         LblSmear.Location = new System.Drawing.Point(37, 122);
         LblSmear.Name = "LblSmear";
         LblSmear.Size = new System.Drawing.Size(58, 13);
         LblSmear.TabIndex = 34;
         LblSmear.Text = "Smeared:";
         LblSmear.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         // 
         // GrpBoxCapMode
         // 
         this.GrpBoxCapMode.BackColor = System.Drawing.Color.Transparent;
         this.GrpBoxCapMode.Controls.Add(this.SmearPct);
         this.GrpBoxCapMode.Controls.Add(LblSmear);
         this.GrpBoxCapMode.Controls.Add(this.ChkAutoCap);
         this.GrpBoxCapMode.Controls.Add(this.ChkRTQA);
         this.GrpBoxCapMode.Controls.Add(this.LightPct);
         this.GrpBoxCapMode.Controls.Add(this.DarkPct);
         this.GrpBoxCapMode.Controls.Add(this.GoodPct);
         this.GrpBoxCapMode.Controls.Add(this.ContactPct);
         this.GrpBoxCapMode.Controls.Add(this.TimeMs);
         this.GrpBoxCapMode.Controls.Add(this.CoverPct);
         this.GrpBoxCapMode.Controls.Add(LblLight);
         this.GrpBoxCapMode.Controls.Add(LblDark);
         this.GrpBoxCapMode.Controls.Add(LblGood);
         this.GrpBoxCapMode.Controls.Add(LblContact);
         this.GrpBoxCapMode.Controls.Add(this.LblTime);
         this.GrpBoxCapMode.Controls.Add(this.LblCover);
         this.GrpBoxCapMode.Controls.Add(this.LblRes);
         this.GrpBoxCapMode.Controls.Add(this.Radio1000);
         this.GrpBoxCapMode.Controls.Add(this.Radio500);
         this.GrpBoxCapMode.Location = new System.Drawing.Point(14, 475);
         this.GrpBoxCapMode.Name = "GrpBoxCapMode";
         this.GrpBoxCapMode.Size = new System.Drawing.Size(243, 184);
         this.GrpBoxCapMode.TabIndex = 16;
         this.GrpBoxCapMode.TabStop = false;
         this.GrpBoxCapMode.Text = "Capture Mode";
         // 
         // SmearPct
         // 
         this.SmearPct.AutoSize = true;
         this.SmearPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.SmearPct.Location = new System.Drawing.Point(100, 122);
         this.SmearPct.Name = "SmearPct";
         this.SmearPct.Size = new System.Drawing.Size(19, 13);
         this.SmearPct.TabIndex = 35;
         this.SmearPct.Text = "   ";
         // 
         // ChkAutoCap
         // 
         this.ChkAutoCap.AutoSize = true;
         this.ChkAutoCap.Checked = true;
         this.ChkAutoCap.CheckState = System.Windows.Forms.CheckState.Checked;
         this.ChkAutoCap.Location = new System.Drawing.Point(16, 21);
         this.ChkAutoCap.Name = "ChkAutoCap";
         this.ChkAutoCap.Size = new System.Drawing.Size(88, 17);
         this.ChkAutoCap.TabIndex = 3;
         this.ChkAutoCap.Text = "Auto Capture";
         this.ChkAutoCap.UseVisualStyleBackColor = true;
         this.ChkAutoCap.CheckedChanged += new System.EventHandler(this.ChkAutoCap_CheckedChanged);
         // 
         // ChkRTQA
         // 
         this.ChkRTQA.AutoSize = true;
         this.ChkRTQA.Checked = true;
         this.ChkRTQA.CheckState = System.Windows.Forms.CheckState.Checked;
         this.ChkRTQA.Location = new System.Drawing.Point(16, 39);
         this.ChkRTQA.Name = "ChkRTQA";
         this.ChkRTQA.Size = new System.Drawing.Size(146, 17);
         this.ChkRTQA.TabIndex = 4;
         this.ChkRTQA.Text = "Real-time Quality Analysis";
         this.ChkRTQA.UseVisualStyleBackColor = true;
         // 
         // LightPct
         // 
         this.LightPct.AutoSize = true;
         this.LightPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.LightPct.Location = new System.Drawing.Point(100, 108);
         this.LightPct.Name = "LightPct";
         this.LightPct.Size = new System.Drawing.Size(19, 13);
         this.LightPct.TabIndex = 30;
         this.LightPct.Text = "   ";
         // 
         // DarkPct
         // 
         this.DarkPct.AutoSize = true;
         this.DarkPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.DarkPct.Location = new System.Drawing.Point(100, 95);
         this.DarkPct.Name = "DarkPct";
         this.DarkPct.Size = new System.Drawing.Size(19, 13);
         this.DarkPct.TabIndex = 29;
         this.DarkPct.Text = "   ";
         // 
         // GoodPct
         // 
         this.GoodPct.AutoSize = true;
         this.GoodPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.GoodPct.Location = new System.Drawing.Point(100, 75);
         this.GoodPct.Name = "GoodPct";
         this.GoodPct.Size = new System.Drawing.Size(19, 13);
         this.GoodPct.TabIndex = 28;
         this.GoodPct.Text = "   ";
         // 
         // ContactPct
         // 
         this.ContactPct.AutoSize = true;
         this.ContactPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.ContactPct.Location = new System.Drawing.Point(100, 60);
         this.ContactPct.Name = "ContactPct";
         this.ContactPct.Size = new System.Drawing.Size(16, 13);
         this.ContactPct.TabIndex = 27;
         this.ContactPct.Text = "   ";
         // 
         // TimeMs
         // 
         this.TimeMs.AutoSize = true;
         this.TimeMs.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.TimeMs.Location = new System.Drawing.Point(184, 75);
         this.TimeMs.Name = "TimeMs";
         this.TimeMs.Size = new System.Drawing.Size(19, 13);
         this.TimeMs.TabIndex = 26;
         this.TimeMs.Text = "   ";
         // 
         // CoverPct
         // 
         this.CoverPct.AutoSize = true;
         this.CoverPct.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.CoverPct.Location = new System.Drawing.Point(184, 61);
         this.CoverPct.Name = "CoverPct";
         this.CoverPct.Size = new System.Drawing.Size(19, 13);
         this.CoverPct.TabIndex = 25;
         this.CoverPct.Text = "   ";
         // 
         // LblTime
         // 
         this.LblTime.Location = new System.Drawing.Point(130, 73);
         this.LblTime.Name = "LblTime";
         this.LblTime.Size = new System.Drawing.Size(49, 16);
         this.LblTime.TabIndex = 1;
         this.LblTime.Text = "Time:";
         this.LblTime.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         this.LblTime.Visible = false;
         // 
         // LblCover
         // 
         this.LblCover.AutoSize = true;
         this.LblCover.Location = new System.Drawing.Point(130, 58);
         this.LblCover.Name = "LblCover";
         this.LblCover.Size = new System.Drawing.Size(49, 13);
         this.LblCover.TabIndex = 0;
         this.LblCover.Text = "% Cover:";
         this.LblCover.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
         this.LblCover.Visible = false;
         // 
         // LblRes
         // 
         this.LblRes.AutoSize = true;
         this.LblRes.Location = new System.Drawing.Point(13, 139);
         this.LblRes.Name = "LblRes";
         this.LblRes.Size = new System.Drawing.Size(60, 13);
         this.LblRes.TabIndex = 33;
         this.LblRes.Text = "Resolution:";
         // 
         // Radio1000
         // 
         this.Radio1000.AutoSize = true;
         this.Radio1000.Location = new System.Drawing.Point(104, 157);
         this.Radio1000.Name = "Radio1000";
         this.Radio1000.Size = new System.Drawing.Size(66, 17);
         this.Radio1000.TabIndex = 6;
         this.Radio1000.Text = "1000 dpi";
         this.Radio1000.UseVisualStyleBackColor = true;
         // 
         // Radio500
         // 
         this.Radio500.AutoSize = true;
         this.Radio500.Checked = true;
         this.Radio500.Location = new System.Drawing.Point(32, 156);
         this.Radio500.Name = "Radio500";
         this.Radio500.Size = new System.Drawing.Size(60, 17);
         this.Radio500.TabIndex = 5;
         this.Radio500.TabStop = true;
         this.Radio500.Text = "500 dpi";
         this.Radio500.UseVisualStyleBackColor = true;
         // 
         // BtnStartCapture
         // 
         this.BtnStartCapture.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.BtnStartCapture.Location = new System.Drawing.Point(40, 428);
         this.BtnStartCapture.Name = "BtnStartCapture";
         this.BtnStartCapture.Size = new System.Drawing.Size(90, 40);
         this.BtnStartCapture.TabIndex = 1;
         this.BtnStartCapture.Text = "CAPTURE";
         this.BtnStartCapture.Click += new System.EventHandler(this.StartCaptureButton_Click);
         // 
         // BtnStopCapture
         // 
         this.BtnStopCapture.Enabled = false;
         this.BtnStopCapture.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.BtnStopCapture.Location = new System.Drawing.Point(143, 428);
         this.BtnStopCapture.Name = "BtnStopCapture";
         this.BtnStopCapture.Size = new System.Drawing.Size(90, 40);
         this.BtnStopCapture.TabIndex = 2;
         this.BtnStopCapture.Text = "ABORT";
         this.BtnStopCapture.Click += new System.EventHandler(this.StopCaptureButton_Click);
         // 
         // ComboDevSel
         // 
         this.ComboDevSel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
         this.ComboDevSel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.ComboDevSel.Font = new System.Drawing.Font("Franklin Gothic Medium Cond", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.ComboDevSel.FormattingEnabled = true;
         this.ComboDevSel.Location = new System.Drawing.Point(13, 180);
         this.ComboDevSel.Name = "ComboDevSel";
         this.ComboDevSel.Size = new System.Drawing.Size(248, 25);
         this.ComboDevSel.TabIndex = 11;
         this.ComboDevSel.SelectedIndexChanged += new System.EventHandler(this.comboDevice_SelectedIndexChanged);
         // 
         // LblStatus
         // 
         this.LblStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                     | System.Windows.Forms.AnchorStyles.Left)
                     | System.Windows.Forms.AnchorStyles.Right)));
         this.LblStatus.AutoSize = true;
         this.LblStatus.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
         this.LblStatus.Location = new System.Drawing.Point(36, 207);
         this.LblStatus.Name = "LblStatus";
         this.LblStatus.Size = new System.Drawing.Size(197, 15);
         this.LblStatus.TabIndex = 12;
         this.LblStatus.Text = "   Device Not Connected   ";
         this.LblStatus.TextAlign = System.Drawing.ContentAlignment.TopCenter;
         // 
         // BtnSaveAs
         // 
         this.BtnSaveAs.Location = new System.Drawing.Point(193, 669);
         this.BtnSaveAs.Name = "BtnSaveAs";
         this.BtnSaveAs.Size = new System.Drawing.Size(64, 28);
         this.BtnSaveAs.TabIndex = 9;
         this.BtnSaveAs.Text = "Save As...";
         this.BtnSaveAs.UseVisualStyleBackColor = true;
         this.BtnSaveAs.Click += new System.EventHandler(this.BtnSaveAs_Click);
         // 
         // BtnExit
         // 
         this.BtnExit.Location = new System.Drawing.Point(194, 703);
         this.BtnExit.Name = "BtnExit";
         this.BtnExit.Size = new System.Drawing.Size(64, 28);
         this.BtnExit.TabIndex = 10;
         this.BtnExit.Text = "Exit";
         this.BtnExit.UseVisualStyleBackColor = true;
         this.BtnExit.Click += new System.EventHandler(this.BtnExit_Click);
         // 
         // ChkRoll
         // 
         this.ChkRoll.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.ChkRoll.Location = new System.Drawing.Point(130, 240);
         this.ChkRoll.Name = "ChkRoll";
         this.ChkRoll.Size = new System.Drawing.Size(11, 10);
         this.ChkRoll.TabIndex = 20;
         this.ChkRoll.UseVisualStyleBackColor = true;
         // 
         // RadioL4
         // 
         this.RadioL4.AutoSize = true;
         this.RadioL4.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(206)))), ((int)(((byte)(189)))), ((int)(((byte)(173)))));
         this.RadioL4.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioL4.ForeColor = System.Drawing.SystemColors.ControlText;
         this.RadioL4.Location = new System.Drawing.Point(58, 236);
         this.RadioL4.Name = "RadioL4";
         this.RadioL4.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioL4.Size = new System.Drawing.Size(13, 12);
         this.RadioL4.TabIndex = 1;
         this.RadioL4.Tag = "TpApi.CaptureType.CTYPE_SLAP_LFOUR";
         this.RadioL4.UseVisualStyleBackColor = false;
         this.RadioL4.CheckedChanged += new System.EventHandler(this.RadioL4_CheckedChanged);
         // 
         // RadioLT
         // 
         this.RadioLT.AutoSize = true;
         this.RadioLT.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLT.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLT.Location = new System.Drawing.Point(115, 310);
         this.RadioLT.Name = "RadioLT";
         this.RadioLT.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLT.Size = new System.Drawing.Size(13, 12);
         this.RadioLT.TabIndex = 2;
         this.RadioLT.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioLT.UseVisualStyleBackColor = false;
         this.RadioLT.CheckedChanged += new System.EventHandler(this.RadioLT_CheckedChanged);
         // 
         // RadioLI
         // 
         this.RadioLI.AutoSize = true;
         this.RadioLI.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLI.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLI.Location = new System.Drawing.Point(88, 270);
         this.RadioLI.Name = "RadioLI";
         this.RadioLI.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLI.Size = new System.Drawing.Size(13, 12);
         this.RadioLI.TabIndex = 3;
         this.RadioLI.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioLI.UseVisualStyleBackColor = false;
         this.RadioLI.CheckedChanged += new System.EventHandler(this.RadioLI_CheckedChanged);
         // 
         // RadioLM
         // 
         this.RadioLM.AutoSize = true;
         this.RadioLM.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLM.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLM.Location = new System.Drawing.Point(68, 259);
         this.RadioLM.Name = "RadioLM";
         this.RadioLM.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLM.Size = new System.Drawing.Size(13, 12);
         this.RadioLM.TabIndex = 4;
         this.RadioLM.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioLM.UseVisualStyleBackColor = false;
         this.RadioLM.CheckedChanged += new System.EventHandler(this.RadioLM_CheckedChanged);
         // 
         // RadioLR
         // 
         this.RadioLR.AutoSize = true;
         this.RadioLR.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLR.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLR.Location = new System.Drawing.Point(48, 268);
         this.RadioLR.Name = "RadioLR";
         this.RadioLR.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLR.Size = new System.Drawing.Size(13, 12);
         this.RadioLR.TabIndex = 5;
         this.RadioLR.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioLR.UseVisualStyleBackColor = false;
         this.RadioLR.CheckedChanged += new System.EventHandler(this.RadioLR_CheckedChanged);
         // 
         // RadioLL
         // 
         this.RadioLL.AutoSize = true;
         this.RadioLL.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLL.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLL.Location = new System.Drawing.Point(30, 279);
         this.RadioLL.Name = "RadioLL";
         this.RadioLL.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLL.Size = new System.Drawing.Size(13, 12);
         this.RadioLL.TabIndex = 6;
         this.RadioLL.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioLL.UseVisualStyleBackColor = false;
         this.RadioLL.CheckedChanged += new System.EventHandler(this.RadioLL_CheckedChanged);
         // 
         // RadioR4
         // 
         this.RadioR4.AutoSize = true;
         this.RadioR4.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(206)))), ((int)(((byte)(189)))), ((int)(((byte)(173)))));
         this.RadioR4.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioR4.Location = new System.Drawing.Point(201, 236);
         this.RadioR4.Name = "RadioR4";
         this.RadioR4.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioR4.Size = new System.Drawing.Size(13, 12);
         this.RadioR4.TabIndex = 7;
         this.RadioR4.Tag = "TpApi.CaptureType.CTYPE_SLAP_RFOUR";
         this.RadioR4.UseVisualStyleBackColor = false;
         this.RadioR4.CheckedChanged += new System.EventHandler(this.RadioR4_CheckedChanged);
         // 
         // RadioRT
         // 
         this.RadioRT.AutoSize = true;
         this.RadioRT.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRT.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRT.Location = new System.Drawing.Point(143, 310);
         this.RadioRT.Name = "RadioRT";
         this.RadioRT.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRT.Size = new System.Drawing.Size(13, 12);
         this.RadioRT.TabIndex = 8;
         this.RadioRT.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioRT.UseVisualStyleBackColor = false;
         this.RadioRT.CheckedChanged += new System.EventHandler(this.RadioRT_CheckedChanged);
         // 
         // RadioRI
         // 
         this.RadioRI.AutoSize = true;
         this.RadioRI.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRI.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRI.Location = new System.Drawing.Point(170, 271);
         this.RadioRI.Name = "RadioRI";
         this.RadioRI.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRI.Size = new System.Drawing.Size(13, 12);
         this.RadioRI.TabIndex = 9;
         this.RadioRI.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioRI.UseVisualStyleBackColor = false;
         this.RadioRI.CheckedChanged += new System.EventHandler(this.RadioRI_CheckedChanged);
         // 
         // RadioRM
         // 
         this.RadioRM.AutoSize = true;
         this.RadioRM.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRM.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRM.Location = new System.Drawing.Point(191, 260);
         this.RadioRM.Name = "RadioRM";
         this.RadioRM.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRM.Size = new System.Drawing.Size(13, 12);
         this.RadioRM.TabIndex = 10;
         this.RadioRM.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioRM.UseVisualStyleBackColor = false;
         this.RadioRM.CheckedChanged += new System.EventHandler(this.RadioRM_CheckedChanged);
         // 
         // RadioRR
         // 
         this.RadioRR.AutoSize = true;
         this.RadioRR.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRR.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRR.Location = new System.Drawing.Point(211, 268);
         this.RadioRR.Name = "RadioRR";
         this.RadioRR.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRR.Size = new System.Drawing.Size(13, 12);
         this.RadioRR.TabIndex = 13;
         this.RadioRR.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioRR.UseVisualStyleBackColor = false;
         this.RadioRR.CheckedChanged += new System.EventHandler(this.RadioRR_CheckedChanged);
         // 
         // RadioRL
         // 
         this.RadioRL.AutoSize = true;
         this.RadioRL.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRL.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRL.Location = new System.Drawing.Point(228, 280);
         this.RadioRL.Name = "RadioRL";
         this.RadioRL.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRL.Size = new System.Drawing.Size(13, 12);
         this.RadioRL.TabIndex = 14;
         this.RadioRL.Tag = "TpApi.CaptureType.CTYPE_ROLL";
         this.RadioRL.UseVisualStyleBackColor = false;
         this.RadioRL.CheckedChanged += new System.EventHandler(this.RadioRL_CheckedChanged);
         // 
         // Radio2T
         // 
         this.Radio2T.AutoSize = true;
         this.Radio2T.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(206)))), ((int)(((byte)(189)))), ((int)(((byte)(173)))));
         this.Radio2T.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.Radio2T.Location = new System.Drawing.Point(129, 278);
         this.Radio2T.Name = "Radio2T";
         this.Radio2T.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.Radio2T.Size = new System.Drawing.Size(13, 12);
         this.Radio2T.TabIndex = 15;
         this.Radio2T.Tag = "TpApi.CaptureType.CTYPE_SLAP_THUMBS";
         this.Radio2T.UseVisualStyleBackColor = false;
         this.Radio2T.CheckedChanged += new System.EventHandler(this.Radio2T_CheckedChanged);
         // 
         // RadioLH
         // 
         this.RadioLH.AutoSize = true;
         this.RadioLH.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(206)))), ((int)(((byte)(189)))), ((int)(((byte)(173)))));
         this.RadioLH.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLH.Location = new System.Drawing.Point(57, 376);
         this.RadioLH.Name = "RadioLH";
         this.RadioLH.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLH.Size = new System.Drawing.Size(13, 12);
         this.RadioLH.TabIndex = 18;
         this.RadioLH.Tag = "TpApi.CaptureType.CTYPE_HAND";
         this.RadioLH.UseVisualStyleBackColor = false;
         this.RadioLH.CheckedChanged += new System.EventHandler(this.RadioLH_CheckedChanged);
         // 
         // RadioRH
         // 
         this.RadioRH.AutoSize = true;
         this.RadioRH.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(206)))), ((int)(((byte)(189)))), ((int)(((byte)(173)))));
         this.RadioRH.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRH.Location = new System.Drawing.Point(201, 376);
         this.RadioRH.Name = "RadioRH";
         this.RadioRH.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRH.Size = new System.Drawing.Size(13, 12);
         this.RadioRH.TabIndex = 19;
         this.RadioRH.Tag = "TpApi.CaptureType.CTYPE_HAND";
         this.RadioRH.UseVisualStyleBackColor = false;
         this.RadioRH.CheckedChanged += new System.EventHandler(this.RadioRH_CheckedChanged);
         // 
         // RadioLP
         // 
         this.RadioLP.AutoSize = true;
         this.RadioLP.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioLP.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioLP.Location = new System.Drawing.Point(58, 334);
         this.RadioLP.Name = "RadioLP";
         this.RadioLP.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioLP.Size = new System.Drawing.Size(13, 12);
         this.RadioLP.TabIndex = 16;
         this.RadioLP.Tag = "TpApi.CaptureType.CTYPE_SLAP_LPALM";
         this.RadioLP.UseVisualStyleBackColor = false;
         this.RadioLP.CheckedChanged += new System.EventHandler(this.RadioLP_CheckedChanged);
         // 
         // RadioRP
         // 
         this.RadioRP.AutoSize = true;
         this.RadioRP.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(222)))), ((int)(((byte)(222)))), ((int)(((byte)(214)))));
         this.RadioRP.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
         this.RadioRP.Location = new System.Drawing.Point(200, 334);
         this.RadioRP.Name = "RadioRP";
         this.RadioRP.RightToLeft = System.Windows.Forms.RightToLeft.No;
         this.RadioRP.Size = new System.Drawing.Size(13, 12);
         this.RadioRP.TabIndex = 17;
         this.RadioRP.Tag = "TpApi.CaptureType.CTYPE_RPALM";
         this.RadioRP.UseVisualStyleBackColor = false;
         this.RadioRP.CheckedChanged += new System.EventHandler(this.RadioRP_CheckedChanged);
         // 
         // tmrChkDev
         // 
         this.tmrChkDev.Interval = 3000;
         this.tmrChkDev.Tick += new System.EventHandler(this.tmrChkDev_Tick);
         // 
         // idxLogo
         // 
         this.idxLogo.Image = global::TPAPI_.NET_Sample_App.Properties.Resources.logoL1ID_172;
         this.idxLogo.InitialImage = null;
         this.idxLogo.Location = new System.Drawing.Point(18, 24);
         this.idxLogo.Name = "idxLogo";
         this.idxLogo.Size = new System.Drawing.Size(172, 134);
         this.idxLogo.TabIndex = 21;
         this.idxLogo.TabStop = false;
         // 
         // PicBoxCapType
         // 
         this.PicBoxCapType.BackColor = System.Drawing.Color.Transparent;
         this.PicBoxCapType.BackgroundImageLayout = System.Windows.Forms.ImageLayout.None;
         this.PicBoxCapType.Image = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_L4;
         this.PicBoxCapType.Location = new System.Drawing.Point(13, 233);
         this.PicBoxCapType.Name = "PicBoxCapType";
         this.PicBoxCapType.Size = new System.Drawing.Size(245, 170);
         this.PicBoxCapType.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
         this.PicBoxCapType.TabIndex = 23;
         this.PicBoxCapType.TabStop = false;
         this.PicBoxCapType.Tag = "";
         // 
         // ImageBox
         // 
         this.ImageBox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                     | System.Windows.Forms.AnchorStyles.Left)
                     | System.Windows.Forms.AnchorStyles.Right)));
         this.ImageBox.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(250)))), ((int)(((byte)(250)))), ((int)(((byte)(250)))));
         this.ImageBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
         this.ImageBox.Location = new System.Drawing.Point(274, 13);
         this.ImageBox.Name = "ImageBox";
         this.ImageBox.Size = new System.Drawing.Size(728, 686);
         this.ImageBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
         this.ImageBox.TabIndex = 8;
         this.ImageBox.TabStop = false;
         // 
         // LblPrompt
         // 
         this.LblPrompt.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                     | System.Windows.Forms.AnchorStyles.Left)
                     | System.Windows.Forms.AnchorStyles.Right)));
         this.LblPrompt.AutoSize = true;
         this.LblPrompt.BackColor = System.Drawing.Color.Transparent;
         this.LblPrompt.CausesValidation = false;
         this.LblPrompt.Font = new System.Drawing.Font("Microsoft Sans Serif", 26F);
         this.LblPrompt.ForeColor = System.Drawing.Color.DarkBlue;
         this.LblPrompt.Location = new System.Drawing.Point(329, 699);
         this.LblPrompt.Margin = new System.Windows.Forms.Padding(0);
         this.LblPrompt.Name = "LblPrompt";
         this.LblPrompt.Size = new System.Drawing.Size(617, 39);
         this.LblPrompt.TabIndex = 0;
         this.LblPrompt.Text = "Center Finger, Rock, then Press SCAN";
         this.LblPrompt.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
         this.LblPrompt.Visible = false;
         // 
         // ChkRT
         // 
         this.ChkRT.AutoSize = true;
         this.ChkRT.Location = new System.Drawing.Point(143, 310);
         this.ChkRT.Name = "ChkRT";
         this.ChkRT.Size = new System.Drawing.Size(15, 14);
         this.ChkRT.TabIndex = 24;
         this.ChkRT.UseVisualStyleBackColor = true;
         this.ChkRT.Visible = false;
         // 
         // ChkRI
         // 
         this.ChkRI.AutoSize = true;
         this.ChkRI.Location = new System.Drawing.Point(169, 271);
         this.ChkRI.Name = "ChkRI";
         this.ChkRI.Size = new System.Drawing.Size(15, 14);
         this.ChkRI.TabIndex = 25;
         this.ChkRI.UseVisualStyleBackColor = true;
         this.ChkRI.Visible = false;
         // 
         // ChkRM
         // 
         this.ChkRM.AutoSize = true;
         this.ChkRM.Location = new System.Drawing.Point(191, 260);
         this.ChkRM.Name = "ChkRM";
         this.ChkRM.Size = new System.Drawing.Size(15, 14);
         this.ChkRM.TabIndex = 26;
         this.ChkRM.UseVisualStyleBackColor = true;
         this.ChkRM.Visible = false;
         // 
         // ChkRR
         // 
         this.ChkRR.AutoSize = true;
         this.ChkRR.Location = new System.Drawing.Point(211, 268);
         this.ChkRR.Name = "ChkRR";
         this.ChkRR.Size = new System.Drawing.Size(15, 14);
         this.ChkRR.TabIndex = 27;
         this.ChkRR.UseVisualStyleBackColor = true;
         this.ChkRR.Visible = false;
         // 
         // ChkRL
         // 
         this.ChkRL.AutoSize = true;
         this.ChkRL.Location = new System.Drawing.Point(227, 280);
         this.ChkRL.Name = "ChkRL";
         this.ChkRL.Size = new System.Drawing.Size(15, 14);
         this.ChkRL.TabIndex = 28;
         this.ChkRL.UseVisualStyleBackColor = true;
         this.ChkRL.Visible = false;
         // 
         // ChkLT
         // 
         this.ChkLT.AutoSize = true;
         this.ChkLT.Location = new System.Drawing.Point(114, 310);
         this.ChkLT.Name = "ChkLT";
         this.ChkLT.Size = new System.Drawing.Size(15, 14);
         this.ChkLT.TabIndex = 29;
         this.ChkLT.UseVisualStyleBackColor = true;
         this.ChkLT.Visible = false;
         // 
         // ChkLI
         // 
         this.ChkLI.AutoSize = true;
         this.ChkLI.Location = new System.Drawing.Point(87, 270);
         this.ChkLI.Name = "ChkLI";
         this.ChkLI.Size = new System.Drawing.Size(15, 14);
         this.ChkLI.TabIndex = 30;
         this.ChkLI.UseVisualStyleBackColor = true;
         this.ChkLI.Visible = false;
         // 
         // ChkLM
         // 
         this.ChkLM.AutoSize = true;
         this.ChkLM.Location = new System.Drawing.Point(68, 259);
         this.ChkLM.Name = "ChkLM";
         this.ChkLM.Size = new System.Drawing.Size(15, 14);
         this.ChkLM.TabIndex = 31;
         this.ChkLM.UseVisualStyleBackColor = true;
         this.ChkLM.Visible = false;
         // 
         // ChkLR
         // 
         this.ChkLR.AutoSize = true;
         this.ChkLR.Location = new System.Drawing.Point(47, 268);
         this.ChkLR.Name = "ChkLR";
         this.ChkLR.Size = new System.Drawing.Size(15, 14);
         this.ChkLR.TabIndex = 32;
         this.ChkLR.UseVisualStyleBackColor = true;
         this.ChkLR.Visible = false;
         // 
         // ChkLL
         // 
         this.ChkLL.AutoSize = true;
         this.ChkLL.Location = new System.Drawing.Point(30, 279);
         this.ChkLL.Name = "ChkLL";
         this.ChkLL.Size = new System.Drawing.Size(15, 14);
         this.ChkLL.TabIndex = 33;
         this.ChkLL.UseVisualStyleBackColor = true;
         this.ChkLL.Visible = false;
         // 
         // ChkDFC
         // 
         this.ChkDFC.AutoSize = true;
         this.ChkDFC.Location = new System.Drawing.Point(213, 407);
         this.ChkDFC.Name = "ChkDFC";
         this.ChkDFC.Size = new System.Drawing.Size(47, 17);
         this.ChkDFC.TabIndex = 34;
         this.ChkDFC.Text = "DFC";
         this.ChkDFC.UseVisualStyleBackColor = true;
         this.ChkDFC.CheckedChanged += new System.EventHandler(this.ChkDFC_CheckedChanged);
         // 
         // chkPollDev
         // 
         this.chkPollDev.AutoSize = true;
         this.chkPollDev.Checked = true;
         this.chkPollDev.CheckState = System.Windows.Forms.CheckState.Checked;
         this.chkPollDev.Location = new System.Drawing.Point(213, 159);
         this.chkPollDev.Name = "chkPollDev";
         this.chkPollDev.Size = new System.Drawing.Size(43, 17);
         this.chkPollDev.TabIndex = 35;
         this.chkPollDev.Text = "Poll";
         this.chkPollDev.UseVisualStyleBackColor = true;
         this.chkPollDev.CheckedChanged += new System.EventHandler(this.chkPollDev_CheckedChanged);
         // 
         // MainForm
         // 
         this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Inherit;
         this.AutoSizeMode = System.Windows.Forms.AutoSizeMode.GrowAndShrink;
         this.ClientSize = new System.Drawing.Size(1018, 743);
         this.Controls.Add(this.chkPollDev);
         this.Controls.Add(this.ChkDFC);
         this.Controls.Add(this.ChkLL);
         this.Controls.Add(this.ChkLR);
         this.Controls.Add(this.ChkLM);
         this.Controls.Add(this.ChkLI);
         this.Controls.Add(this.ChkLT);
         this.Controls.Add(this.ChkRL);
         this.Controls.Add(this.ChkRR);
         this.Controls.Add(this.ChkRM);
         this.Controls.Add(this.ChkRI);
         this.Controls.Add(this.ChkRT);
         this.Controls.Add(this.LblPrompt);
         this.Controls.Add(this.idxLogo);
         this.Controls.Add(this.ComboDevSel);
         this.Controls.Add(this.LblStatus);
         this.Controls.Add(this.RadioL4);
         this.Controls.Add(this.RadioLT);
         this.Controls.Add(this.RadioLI);
         this.Controls.Add(this.RadioLM);
         this.Controls.Add(this.RadioLR);
         this.Controls.Add(this.RadioLL);
         this.Controls.Add(this.RadioR4);
         this.Controls.Add(this.RadioRT);
         this.Controls.Add(this.RadioRI);
         this.Controls.Add(this.RadioRM);
         this.Controls.Add(this.RadioRR);
         this.Controls.Add(this.RadioRL);
         this.Controls.Add(this.Radio2T);
         this.Controls.Add(this.RadioLP);
         this.Controls.Add(this.RadioRP);
         this.Controls.Add(this.RadioLH);
         this.Controls.Add(this.RadioRH);
         this.Controls.Add(this.ChkRoll);
         this.Controls.Add(this.PicBoxCapType);
         this.Controls.Add(this.BtnStartCapture);
         this.Controls.Add(this.BtnStopCapture);
         this.Controls.Add(this.GrpBoxCapMode);
         this.Controls.Add(GrpBoxCal);
         this.Controls.Add(this.BtnSaveAs);
         this.Controls.Add(this.BtnExit);
         this.Controls.Add(this.ImageBox);
         this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
         this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
         this.MaximizeBox = false;
         this.Name = "MainForm";
         this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
         this.Text = "TPAPI .NET Sample Application - Initializing Please Wait";
         this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.MainForm_FormClosing);
         this.Load += new System.EventHandler(this.MainForm_Load);
         GrpBoxCal.ResumeLayout(false);
         this.GrpBoxCapMode.ResumeLayout(false);
         this.GrpBoxCapMode.PerformLayout();
         ((System.ComponentModel.ISupportInitialize)(this.idxLogo)).EndInit();
         ((System.ComponentModel.ISupportInitialize)(this.PicBoxCapType)).EndInit();
         ((System.ComponentModel.ISupportInitialize)(this.ImageBox)).EndInit();
         this.ResumeLayout(false);
         this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

      //==========================================================================
      // Drawing Methods
      //==========================================================================
      private System.Drawing.Imaging.PixelFormat m_format = 
         System.Drawing.Imaging.PixelFormat.Format8bppIndexed;
		private ColorPalette gPalette = null;
		private void greyPalette()
		{
			if (gPalette == null)
			{
				Bitmap b = new Bitmap(16, 16, m_format);
				// Create a grayscale palette
				gPalette = b.Palette;
				for(int i = 0; i < b.Palette.Entries.Length; i++)
				{
					gPalette.Entries[i] = Color.FromArgb( i, i, i);
				}
			}
		}

		private ColorPalette dPalette = null;
		private void decoratedPalette()
		{
			if (dPalette == null)
			{
				Bitmap b = new Bitmap(16, 16, m_format);
				// Setup the palette with IQC colors (128 shades of red and 
				// 128 shades of gray)
				dPalette = b.Palette;
				for(int i = 0; i < b.Palette.Entries.Length; i++)
				{
					if ( i == 0 || i % 2 == 0)
					{	// even (gray)
						dPalette.Entries[i] = Color.FromArgb(i, i, i);
					}
					else
					{	// odd (red)
						dPalette.Entries[i] = Color.FromArgb(255, i, i);   
					}
				}
			}
		}

		private ColorPalette sPalette = null;
		private void speedPalette()
		{
			if (sPalette == null)
			{
				Bitmap b = new Bitmap(16, 16, m_format);
				// Setup the palette with IQC colors (128 shades of red and 
				// 128 shades of gray)
				sPalette = b.Palette;
				sPalette.Entries[0] = Color.Red;
				sPalette.Entries[1] = Color.Yellow;
				sPalette.Entries[2] = Color.MediumSeaGreen;
				sPalette.Entries[3] = Color.Blue;

				for(int i = 4; i < b.Palette.Entries.Length; i++)
				{
					sPalette.Entries[i] = Color.FromArgb(i, i, i);
				}
			}
		}

		private bool drawing = false;
		private void DrawFrame(ushort xsize, ushort ysize, byte[] imageBuf, 
         ColorPalette palette, int x, int y, int width, int height)
		{
			Bitmap bitmap;

			lock (ImageBox)
			{
				if (drawing) return;
				drawing = true;
			}
			byte[] imageBytes;
			int stride = 4 - (xsize % 4);
			if (stride == 4)
			{
				stride = 0;
				imageBytes = imageBuf;
			}
			else
			{
				imageBytes = new byte[(xsize + stride) * ysize];
				int i = 0;
				int ii = 0;
				for (int yy = 0; yy < ysize; ++ yy)
				{
					for (int xx = 0; xx < xsize; ++ xx)
						imageBytes[ii++] = imageBuf[i++];
					for (int xx = 0; xx < stride; ++xx)
						imageBytes[ii++] = 0xff;
				}
			}
			stride += xsize;
			unsafe 
			{
				fixed (byte *p = imageBytes) 
				{
					bitmap = new Bitmap(xsize, ysize, stride, m_format, (System.IntPtr)p);
				}                                                                      
			}
			bitmap.Palette = palette;
         bitmap.SetResolution(m_capRes, m_capRes);
         ImageBox.Image = bitmap;
         drawing = false;
		}

      private Rectangle ImageShrinkToFit(Size imgSz, Rectangle maxImgArea)
      {  // Shrink the input image to fit in the maxImgArea 
         // while maintaining its original aspect ratio
         Rectangle wImgArea = new Rectangle();
         wImgArea.Height = imgSz.Height;
         wImgArea.Width = imgSz.Width & ~0x03;
         if (wImgArea.Height > maxImgArea.Height)
         {
            wImgArea.Height = maxImgArea.Height;
            wImgArea.Width = ((wImgArea.Height * imgSz.Width)
                                 / imgSz.Height) & ~0x03;
         }
         if (wImgArea.Width > maxImgArea.Width)
         {
            wImgArea.Width = maxImgArea.Width & ~0x03;
            wImgArea.Height = (wImgArea.Width * imgSz.Height) / imgSz.Width;
         }
         wImgArea.X = maxImgArea.Left + (maxImgArea.Width - wImgArea.Width) / 2;
         wImgArea.Y = maxImgArea.Top + (maxImgArea.Height - wImgArea.Height) / 2;
         return wImgArea;
      }

      //--------------------------------------------------------------------------
      // Form Load Event Handler
      //--------------------------------------------------------------------------
      private void MainForm_Load(object sender, EventArgs e)
      {
         try
         {     // load animated cursor
            Assembly asm = Assembly.GetExecutingAssembly();
            Stream resStream = asm.GetManifestResourceStream("TPAPI_.NET_Sample_App.Resources.L1ID.ani");
            byte[] curBytes = new byte[resStream.Length];
            resStream.Read(curBytes, 0, curBytes.GetLength(0));
            aniCursor = AdvancedCursors.Create(curBytes);
         }
         catch (Exception err) { MessageBox.Show(err.Message); }

         this.tmrChkDev.Interval = 500;
         this.tmrChkDev.Start();
      }

      //--------------------------------------------------------------------------
      // Form Closing Event Handler
      //--------------------------------------------------------------------------
      private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
      {
         if (m_bCaptureInProgress)
            e.Cancel = true;
         else
         {
            if (m_Device != null)
               m_Device.CloseDevice();
            cTpApi.TpApi_TerminateAPI();
         }
      }

      //--------------------------------------------------------------------------
      // EnableGUI
      //--------------------------------------------------------------------------
      private void EnableGUI(bool bEnable)
      {
         this.ComboDevSel.Enabled = bEnable;
         this.RadioL4.Enabled = bEnable;
         this.RadioLT.Enabled = bEnable;
         this.RadioLI.Enabled = bEnable;
         this.RadioLM.Enabled = bEnable;
         this.RadioLR.Enabled = bEnable;
         this.RadioLL.Enabled = bEnable;
         this.RadioR4.Enabled = bEnable;
         this.RadioRT.Enabled = bEnable;
         this.RadioRI.Enabled = bEnable;
         this.RadioRM.Enabled = bEnable;
         this.RadioRR.Enabled = bEnable;
         this.RadioRL.Enabled = bEnable;
         this.Radio2T.Enabled = bEnable;
         this.RadioLP.Enabled = bEnable;
         this.RadioRP.Enabled = bEnable;
         this.RadioLH.Enabled = bEnable;
         this.RadioRH.Enabled = bEnable;
         this.ChkDFC.Enabled = bEnable;

         if (bEnable)
         {
            this.ChkRoll.Enabled = m_bChkRollEnabled;
            this.ChkAutoCap.Enabled = m_bChkAutoCapEnabled;
            bool isSupported = false;
            if (m_Device.IsCalibrationSupported(
               TpApiDevice.eCaptureType.CTYPE_HAND, ref isSupported)
                  == TpApiError.TPAPI_NOERROR)
               this.BtnCalDrum.Enabled = isSupported;
            else this.BtnCalDrum.Enabled = false;
         }
         else
         {     // save current state, restore on enable
            m_bChkRollEnabled = this.ChkRoll.Enabled;
            m_bChkAutoCapEnabled = this.ChkAutoCap.Enabled;
            this.ChkRoll.Enabled = false;
            this.ChkAutoCap.Enabled = false;
            this.BtnCalDrum.Enabled = false;
         }
         this.ChkRTQA.Enabled = bEnable;
         this.LblRes.Enabled = bEnable;
         this.Radio500.Enabled = bEnable;
         this.Radio1000.Enabled = bEnable;
         this.BtnCalPlaten.Enabled = bEnable;
         this.BtnSaveAs.Enabled = bEnable;
         this.BtnExit.Enabled = bEnable;
         this.ImageBox.Enabled = true;
      }

      //--------------------------------------------------------------------------
      // Capture Cleanup
      //--------------------------------------------------------------------------
      private void CaptureCleanup(bool bClrImg)
      {
         if (bClrImg)
         {
            this.ImageBox.Image = null;
            imageGraphic.Clear(ImageBox.BackColor);
         }
         EnableGUI(true);
         m_bCaptureInProgress = false;
         m_capState = TpApiDevice.eCaptureState.CSTATE_IDLE;
         this.BtnStartCapture.Text = "CAPTURE";
         this.BtnStopCapture.Text = "ABORT";
         this.BtnStopCapture.Enabled = false;
         this.LblPrompt.Hide();
         this.Cursor = Cursors.Default;
      }

      //--------------------------------------------------------------------------
      /// <summary>
      /// Get Device make, Model, SN and Firmware version.
      /// </summary>
      //--------------------------------------------------------------------------
      private void GetDeviceInfo()
      {
         TpApiDevice.s_devInfo info = new TpApiDevice.s_devInfo();

         TpApiError r = m_Device.GetDeviceInfo(ref info);
         if (r == TpApiError.TPAPI_NOERROR)
         {
            m_devInfo.Make = "";
            for (int i = 0; i < info.assy_make.Length && info.assy_make[i] != '\0'; ++i)
               m_devInfo.Make += info.assy_make[i].ToString();

            m_devInfo.Model = "";
            for (int i = 0; i < info.assy_model.Length && info.assy_model[i] != '\0'; ++i)
               m_devInfo.Model += info.assy_model[i].ToString();

            m_devInfo.SN = "";
            for (int i = 0; i < info.assy_sn.Length && info.assy_sn[i] != '\0'; ++i)
               m_devInfo.SN += info.assy_sn[i].ToString();

            m_devInfo.Version = "";
            for (int i = 0; i < info.sw_version.Length && info.sw_version[i] != '\0'; ++i)
               m_devInfo.Version += info.sw_version[i].ToString();
         }
         else MessageBox.Show(r + " error retrieving deviceInfo",
            "GetDeviceInfo Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
      }

      //--------------------------------------------------------------------------
      /// Initialize the device interface
      //--------------------------------------------------------------------------
      private void InitScannerAPI()
      {
         if (!m_initialized)
         {
            m_initialized = true;
            EnableGUI(false);
            BtnStartCapture.Enabled = false;
            this.Cursor = aniCursor;

            this.Text = strAppName + " - Initializing...Please Wait";
            if (cTpApi.TpApi_InitializeApi() == TpApiError.TPAPI_NOERROR)
            {
               uint numDev = 8;
               TpApiError r = cTpApi.TpApi_GetDeviceList(ref numDev, ref this.m_tpDevices);
               if (r != TpApiError.TPAPI_NOERROR) numDev = 0;

               String[] strLink = { "USB 2.0", "IEEE1394 OHCI", "IEEE1394 UB" };
               for (int ii = 0; ii < numDev; ii++)
               {
                  TpApi.s_regDevInfo info = m_tpDevices[ii].GetRegDevInfo();
                  string Model = "";
                  for (int i = 0; i < info.assy_model.Length && info.assy_model[i] != '\0'; ++i)
                     Model += info.assy_model[i].ToString();

                  string SN = "";
                  for (int i = 0; i < info.assy_sn.Length && info.assy_sn[i] != '\0'; ++i)
                     SN += info.assy_sn[i].ToString();

                  ComboDevSel.Items.Add(" " + Model + " - S/N " + SN + " - " +
                     ((info.libType < 3) ? strLink[info.libType] : "Unknown"));
               }
               if (numDev > 0)
               {
                  RadioL4.Checked = true;
                  m_capTypeSave = TpApiDevice.eCaptureType.CTYPE_SLAP_LFOUR;
                  ComboDevSel.SelectedIndex = 0;
                  this.tmrChkDev.Interval = 3000;
                  EnableGUI(true);
                  BtnStartCapture.Enabled = true;
               }
               else
               {
                  this.Text = strAppName;
                  this.tmrChkDev.Stop();
               }
            }
            else
            {
               this.Text = strAppName + " - ## Initialization Error ##";
            }
#if USE_USBHIDIO
            if ((m_FootSw.GetDevicesCount() == 1) && (m_FootSw.Open() == 0))
               this.tmrChkFsw.Start();
#endif
            this.Cursor = Cursors.Default;
            BtnExit.Enabled = true;
         }
      }

      //==========================================================================
      // Timer Handlers
      //==========================================================================
      private void tmrChkDev_Tick(object sender, EventArgs e)
      {
         if (!m_initialized)
            InitScannerAPI();

         bool bConnected = m_Device != null ? m_Device.DeviceConnected() : false;
         if (bConnected && !m_Connected)
         {
            m_Connected = true;
            GetDeviceInfo();
            this.Text = strAppName + " - " + m_devInfo.Make +
               " " + m_devInfo.Model + " - Serial No. " + m_devInfo.SN;
            this.LblStatus.Text = "==   Firmware Version: " + m_devInfo.Version + "   ==";

            AutoCap_CheckedChanged();

            bool isSupported = false;
            if (m_Device.IsCalibrationSupported(TpApiDevice.eCaptureType.CTYPE_HAND,
                  ref isSupported) == TpApiError.TPAPI_NOERROR)
               BtnCalDrum.Enabled = isSupported;

            uint iRes = 0;
            if (m_Device.GetResolution(m_capType, ref iRes) == TpApiError.TPAPI_NOERROR)
            {
               m_capRes = iRes;
               this.Radio500.Checked = false;
               this.Radio1000.Checked = false;
               if (iRes == 500)
                  this.Radio500.Checked = true;
               else if (iRes == 1000)
                  this.Radio1000.Checked = true;
            }
            this.Refresh();
         }
         else if (!bConnected && m_Connected)
         {
            m_Connected = false;
            this.Text = strAppName;
            this.LblStatus.Text = "   Device Not Connected   ";
         }
      }

#if USE_USBHIDIO
      /* Add to InitializeComponents:      
         this.tmrChkFsw = new System.Windows.Forms.Timer(this.components);
         // tmrChkFsw
         // 
         this.tmrChkFsw.Interval = 150;
         this.tmrChkFsw.Tick += new System.EventHandler(this.tmrChkFsw_Tick);
         // 
      */
      private void tmrChkFsw_Tick(object sender, EventArgs e)
      {
         UInt32 Port0 = 0;
         if (m_FootSw.ReadPort0(ref Port0) == 0)
         {
            Port0 = ~Port0; // invert to ports values
            if (((0x1 & (Port0 >> 1)) != 0) && BtnStopCapture.Enabled)
               StopCaptureButton_Click(null, null);
            else if (((0x1 & (Port0 >> 0)) != 0) && BtnStartCapture.Enabled)
               StartCaptureButton_Click(null, null);
         }
      }
#endif
      //-----------------------------------------------------
      //		SetUIProgress
      //			Set UI progress LEDs
      //-----------------------------------------------------
      TpApiError SetUIProgress(TpApiDevice.eCaptureType capType, 
         TpApiDevice.eLEDState LEDState, bool PreserveFC)
      {
         TpApiError r = TpApiError.TPAPI_NOERROR;
         TpApiDevice.s_442TriLED UILEDs = new TpApiDevice.s_442TriLED();
	      bool bUISupported = false;

      	// set LED
         if ((m_Device.IsDeviceUISupported(TpApiDevice.eUIType.UI_4_4_2_TRI_LED,
           ref bUISupported) == TpApiError.TPAPI_NOERROR) && bUISupported)
	      {
		      if (PreserveFC)
		      {
               if ((r = m_Device.GetDeviceUI(TpApiDevice.eUIType.UI_4_4_2_TRI_LED,
                  ref UILEDs)) != TpApiError.TPAPI_NOERROR) return (r);
               UILEDs.left_four_progress = TpApiDevice.eLEDState.UI_LED_OFF;
               UILEDs.right_four_progress = TpApiDevice.eLEDState.UI_LED_OFF;
               UILEDs.thumb_progress = TpApiDevice.eLEDState.UI_LED_OFF;
		      }

            if (capTypeInfo[(int)m_capType].statusLED == LED_LEFT)
			      UILEDs.left_four_progress = LEDState;
            else if (capTypeInfo[(int)m_capType].statusLED == LED_RIGHT)
			      UILEDs.right_four_progress = LEDState;
            else if (capTypeInfo[(int)m_capType].statusLED == LED_MID)
			      UILEDs.thumb_progress = LEDState;
            r = m_Device.SetDeviceUI(TpApiDevice.eUIType.UI_4_4_2_TRI_LED, UILEDs);
	      }
	      return r;
      }

      //==========================================================================
      // PreviewInvoke
      //==========================================================================
      private void PreviewInvoke()
		{
         if (m_imageBuf != null && m_imageBuf.Length != 0)
         {
            switch (m_capState)
            {
               case TpApiDevice.eCaptureState.CSTATE_PREVIEW:
                  if (m_capType == TpApiDevice.eCaptureType.CTYPE_HAND)
                     DrawFrame(m_xsize, m_ysize, m_imageBuf, sPalette, 0, 0,
                        ImageBox.Width, ImageBox.Height);
                  else
                     DrawFrame(m_xsize, m_ysize, m_imageBuf, gPalette, 0, 0,
                        ImageBox.Width, ImageBox.Height);

                  this.ImageBox.Invalidate();
                  this.LblPrompt.Invalidate();
#if DISPLAY_FPS
                  if (++numFrms >= 2)
                  {
                     curTime = DateTime.Now;
                     if (numFrms == 2)
                        startTime = curTime;
                     if (curTime > startTime)
                     {
                        float fps = ((float)(numFrms - 2) * 10000000) / 
                           (float)(curTime.Ticks - startTime.Ticks);
                        LblFPS.Text = fps + " fps";
                        LblFPS.Visible = true;
                     }
                  }
#endif
                  break;

               case TpApiDevice.eCaptureState.CSTATE_STARTED:
                  TpApiDevice.eCaptureType baseType = capTypeInfo[(int)m_capType].base_ctype;
                  if (baseType == TpApiDevice.eCaptureType.CTYPE_ROLL)
                     this.LblPrompt.Text = "Roll Finger";
                  else if (baseType == TpApiDevice.eCaptureType.CTYPE_HAND)
                     this.LblPrompt.Text = "Pull Hand Toward Subject";
                  this.LblPrompt.Left = ImageBox.Location.X + (ImageBox.Size.Width / 2) - (this.LblPrompt.Size.Width / 2);
                  this.ImageBox.Invalidate();
                  this.Invalidate();
                  this.LblPrompt.Show();
                  this.LblPrompt.Invalidate();
                  this.Cursor = aniCursor;
                  break;

               case TpApiDevice.eCaptureState.CSTATE_CAPTURED:
                  this.LblPrompt.ResetText();
                  if (m_capType == TpApiDevice.eCaptureType.CTYPE_HAND)
                  {
                     this.ImageBox.Top = m_imgArea.Top + (m_imgArea.Height - m_ysize) / 2;
                     this.ImageBox.Height = m_ysize;
                  }
                  DrawFrame(m_xsize, m_ysize, m_imageBuf, dPalette, 0, 0, 
                     ImageBox.Width, ImageBox.Height);

                  ContactPct.Text = m_quality.contact_area.ToString();
                  GoodPct.Text = m_quality.good_area.ToString();
                  DarkPct.Text = m_quality.dark_area.ToString();
                  LightPct.Text = m_quality.light_area.ToString();
                  SmearPct.Text = m_quality.smear_area.ToString();
                  if (ChkRoll.Checked)
                  {
                     CoverPct.Text = m_quality.cover_factor.ToString();
                     TimeMs.Text = m_quality.roll_time.ToString() + " ms";
                     LblCover.Visible = true;
                     CoverPct.Visible = true;
                     LblTime.Visible = true;
                     TimeMs.Visible = true;
                  }
                  else
                  {
                     LblCover.Visible = false;
                     CoverPct.Visible = false;
                     LblTime.Visible = false;
                     TimeMs.Visible = false;
                  }
                  LblPrompt.Text = "Review Image";
                  LblPrompt.Left = ImageBox.Location.X + (ImageBox.Size.Width / 2) - (LblPrompt.Size.Width / 2);
                  LblPrompt.Invalidate();
                  this.BtnStartCapture.Text = "ACCEPT";
                  this.BtnStopCapture.Text = "REJECT";
                  this.Cursor = Cursors.Default;
                  this.Invalidate();
                  break;

               case TpApiDevice.eCaptureState.CSTATE_FINISHED:
                  finishedImageBuf = m_imageBuf;
                  finishedXsize = m_xsize;
                  finishedYsize = m_ysize;

                  if (m_capType == TpApiDevice.eCaptureType.CTYPE_HAND)
                  {
                     Size finImgSz = new Size();
                     finImgSz.Width = finishedXsize;
                     finImgSz.Height = finishedYsize;
                     Rectangle imgArea = new Rectangle(ImageBox.Left, ImageBox.Top, 
                        ImageBox.Width, ImageBox.Height);
                     imgArea = ImageShrinkToFit(finImgSz, imgArea);
                     DrawFrame(finishedXsize, finishedYsize, finishedImageBuf,
                        gPalette, imgArea.Left, imgArea.Top, imgArea.Width, imgArea.Height);
                  }
                  else
                     DrawFrame(finishedXsize, finishedYsize, finishedImageBuf, 
                        gPalette, 0, 0, ImageBox.Width, ImageBox.Height);

                  SetUIProgress(m_capType, TpApiDevice.eLEDState.UI_LED_GREEN, false);
                  CaptureCleanup(false);
                  break;

                  // Other Final Capture States
               case TpApiDevice.eCaptureState.CSTATE_ABORTED:
                  SetUIProgress(m_capType, TpApiDevice.eLEDState.UI_LED_RED, false);
                  CaptureCleanup(true);
                  break;
               case TpApiDevice.eCaptureState.CSTATE_CANCELED:
                  SetUIProgress(m_capType, TpApiDevice.eLEDState.UI_LED_RED, false);
                  CaptureCleanup(true);
                  break;
               case TpApiDevice.eCaptureState.CSTATE_FAILED:
                  MessageBox.Show("Image Capture Failed",
                      "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                  CaptureCleanup(true);
                  break;
               case TpApiDevice.eCaptureState.CSTATE_REJECTED:
                  CaptureCleanup(true);
                  break;
               case TpApiDevice.eCaptureState.CSTATE_TOOFAST:
                  MessageBox.Show("Hand Rolled Too Fast or Too Slow, Capture Failed",
                      "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                  CaptureCleanup(true);
                  break;
            }
         }
		}

      //==========================================================================
      // PreviewCallBack
      //==========================================================================
      private int PreviewCallBack(TpApiDevice.eCaptureState CaptureState, byte[] ImageBuf, Size imgSz)
		{
			m_capState = CaptureState;
         if (m_capState == TpApiDevice.eCaptureState.CSTATE_PREVIEW)
         {
            if (m_capType == TpApiDevice.eCaptureType.CTYPE_HAND)
            {
               int lineNum = imgSz.Height;
               if (lineNum < m_ysize)
               {
                  int numLines = m_ysize - lineNum;
                  if (numLines > BANDED_LINES) numLines = BANDED_LINES;
                  for (int i = 0; i < numLines; i++)
                  {     // flip lines
                     int srcIdx = i * imgSz.Width;
                     int dstIdx = ((m_ysize - 1) - (imgSz.Height + i)) * m_xsize;
                     for (int j = 0; j < imgSz.Width; j++)
                        m_imageBuf[dstIdx + j] = ImageBuf[srcIdx + j];
                  }
               }
            }
            else
            {
               m_xsize = (ushort)imgSz.Width; m_ysize = (ushort)imgSz.Height;
               m_imageBuf = ImageBuf;
            }
         }
         else if ((m_capState == TpApiDevice.eCaptureState.CSTATE_CAPTURED) ||
                  (m_capState == TpApiDevice.eCaptureState.CSTATE_FINISHED))
         {
            m_xsize = (ushort)imgSz.Width; m_ysize = (ushort)imgSz.Height;
            m_imageBuf = ImageBuf;
         }

            // Required here due to BeginInvoke vs Invoke
         if (m_imageBuf != null && m_imageBuf.Length != 0)
            if (m_capState == TpApiDevice.eCaptureState.CSTATE_CAPTURED)
               m_Device.GetImageQA(ref m_quality);

            // BeginInvoke used to prevent deadlock in CancelCapture
         BeginInvoke(PreviewMethod);
			return 0;
		}

      //==========================================================================
      //                         GUI Handlers
      //==========================================================================
      private void BtnExit_Click(object sender, EventArgs e)
      {
         Close();
      }

      //--------------------------------------------------------------------------
      // Save Image to File
      //--------------------------------------------------------------------------
      private void BtnSaveAs_Click(object sender, EventArgs e)
      {
         SaveFileDialog dlgSaveAs = new SaveFileDialog();
         dlgSaveAs.DefaultExt = "bmp";
         dlgSaveAs.Filter = "Bitmap Image Files (*.bmp)|*.bmp;";
         dlgSaveAs.ShowDialog();
         if (dlgSaveAs.FileName.Length > 0)
            try
            {
               ImageBox.Image.Save(dlgSaveAs.FileName, ImageFormat.Bmp);
            }
            catch (Exception ex)
            {
               MessageBox.Show("Error saving image to " + dlgSaveAs.FileName 
                  + "!\n\n" + ex.ToString(), "Save Image", 
                  MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
      }

      //--------------------------------------------------------------------------
      // StartCaptureButton_Click
      //--------------------------------------------------------------------------
      private void StartCaptureButton_Click(object sender, System.EventArgs e)
		{
         this.Cursor = aniCursor;
         if (m_capState == TpApiDevice.eCaptureState.CSTATE_IDLE)
         {
            EnableGUI(false);
            this.BtnStopCapture.Enabled = false;
            bool isSupported = false;

            // Distinguish Rolled vs. Plain Thumb capture
            if (ChkRoll.Visible && (ChkRoll.CheckState == CheckState.Checked))
            {
               if (m_capType == TpApiDevice.eCaptureType.CTYPE_SLAP_LTHUMB)
                  m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_LTHUMB;
               else if (m_capType == TpApiDevice.eCaptureType.CTYPE_SLAP_RTHUMB)
                  m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_RTHUMB;
            }
            else
            {
               if (m_capType == TpApiDevice.eCaptureType.CTYPE_ROLL_LTHUMB)
                  m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_LTHUMB;
               else if (m_capType == TpApiDevice.eCaptureType.CTYPE_ROLL_RTHUMB)
                  m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_RTHUMB;
            }
            m_baseType = capTypeInfo[(int)m_capType].base_ctype;

            // Verify capture type selected is supported on the attached device
            TpApiError r = m_Device.IsCaptureTypeSupported(m_capType, ref isSupported);
            if ((r != TpApiError.TPAPI_NOERROR) || !isSupported)
            {
               if (r != TpApiError.TPAPI_NOERROR)
                  MessageBox.Show(r + " error querying capture type support",
                      "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               else
                  MessageBox.Show("The selected capture type is not supported on the attached device",
                      "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               this.Cursor = Cursors.Default;
               EnableGUI(true);
               return;
            }

            // Verify attached device has been calibrated for selected capture type
            r = m_Device.IsCalibrated(m_baseType, ref isSupported);
            if ((r != TpApiError.TPAPI_NOERROR) || !isSupported)
            {
               if (r != TpApiError.TPAPI_NOERROR)
                  MessageBox.Show(r + " error querying IsCalibrated support",
                      "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               else
		            MessageBox.Show("The scanner requires calibration prior to " +
			            "capturing fingerprints.  Please \n\rcalibrate the " +
			            "scanner for the selected capture type, and retry " +
			            "the capture.    \n\r\n\rPress OK to continue",
                     "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               this.Cursor = Cursors.Default;
               EnableGUI(true);
               return;
            }
            //-----------------------------
            // Set Image Window Size
            //-----------------------------
            Size maxVideoSize = new Size(0, 0);
            r = m_Device.GetMaxVideoSize(m_capType, ref maxVideoSize);
            if (r != TpApiError.TPAPI_NOERROR)
            {
               MessageBox.Show(r + " error querying maximum video size",
                  "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               this.Cursor = Cursors.Default;
               EnableGUI(true);
               return;
            }
            maxVideoSize.Width = maxVideoSize.Width & ~0x03;
            Rectangle imgArea = new Rectangle(m_imgArea.Left, 
               m_imgArea.Top, m_imgArea.Width, m_imgArea.Height);
            imgArea = ImageShrinkToFit(maxVideoSize, imgArea);
            ImageBox.Left = imgArea.Left;
            ImageBox.Top = imgArea.Top;
            ImageBox.Size = imgArea.Size;
            ImageBox.Image = null;
            imageGraphic.Clear(ImageBox.BackColor);

            //-----------------------------
            // Image Resolution
            //-----------------------------
            if (this.Radio1000.Checked)
            {
               if (m_Device.SetResolution(m_capType, 1000) == TpApiError.TPAPI_NOERROR)
                  m_capRes = 1000F;
               else { m_capRes = 500F; this.Radio500.Checked = true; }
            }
            else
            {
               uint iRes = 0;
               if ((m_Device.GetResolution(m_capType, ref iRes) ==
                     TpApiError.TPAPI_NOERROR) && (iRes != 500))
                  m_Device.SetResolution(m_capType, 500);
               m_capRes = 500F;
            }
            this.Refresh();

            SetUIProgress(m_capType, TpApiDevice.eLEDState.UI_LED_YELLOW, true);

            //-----------------------------
            // Kick-off the Capture
            //-----------------------------
            TpApiDevice.eCaptureMode capMode = 
               (this.ChkAutoCap.Checked ? TpApiDevice.eCaptureMode.CMODE_AUTO_CAP : 0) |
               (this.ChkRTQA.Checked ? TpApiDevice.eCaptureMode.CMODE_RTQA|
                  TpApiDevice.eCaptureMode.CMODE_REVIEW : 0);
#if DISPLAY_FPS
            numFrms = 0;
#endif
            if (ChkDFC.Checked)
            {
               uint dfcMap = (ChkRT.Checked ? TpApiDevice.BIT_RTHUMB  : 0) |
                             (ChkRI.Checked ? TpApiDevice.BIT_RINDEX  : 0) |
                             (ChkRM.Checked ? TpApiDevice.BIT_RMIDDLE : 0) |
                             (ChkRR.Checked ? TpApiDevice.BIT_RRING   : 0) |
                             (ChkRL.Checked ? TpApiDevice.BIT_RLITTLE : 0) |
                             (ChkLT.Checked ? TpApiDevice.BIT_LTHUMB  : 0) |
                             (ChkLI.Checked ? TpApiDevice.BIT_LINDEX  : 0) |
                             (ChkLM.Checked ? TpApiDevice.BIT_LMIDDLE : 0) |
                             (ChkLR.Checked ? TpApiDevice.BIT_LRING   : 0) |
                             (ChkLL.Checked ? TpApiDevice.BIT_LLITTLE : 0);
               r = m_Device.StartPreviewDFC(m_capType, capMode, dfcMap, ImageBox.Size);
            }
            else
               r = m_Device.StartPreview(m_capType, capMode, ImageBox.Size);
            if (r != TpApiError.TPAPI_NOERROR)
            {
               MessageBox.Show("StartCapture Error: " + r,
                  "Capture Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
               SetUIProgress(m_capType, TpApiDevice.eLEDState.UI_LED_RED, false);
               EnableGUI(true);
            }
            else
            {
               m_xsize = (ushort)ImageBox.Width;
               m_ysize = (ushort)ImageBox.Height;
               m_imageBuf = new byte[m_xsize * m_ysize];
               for (int i = 0; i < (m_xsize * m_ysize); i++)
                  m_imageBuf[i] = 255;
               m_bCaptureInProgress = true;
               this.BtnStopCapture.Enabled = true;
               m_capState = TpApiDevice.eCaptureState.CSTATE_PREVIEW;

               if (m_baseType == TpApiDevice.eCaptureType.CTYPE_ROLL)
                  this.LblPrompt.Text = "Center Finger, Rock";
               else if (m_baseType == TpApiDevice.eCaptureType.CTYPE_HAND)
                  this.LblPrompt.Text = "Place Hand";
               else if (m_baseType == TpApiDevice.eCaptureType.CTYPE_SLAP_PALM)
                  this.LblPrompt.Text = "Place Palm";
               else if (m_baseType == TpApiDevice.eCaptureType.CTYPE_SLAP_ONE)
                  this.LblPrompt.Text = "Position Thumb";
               else
                  this.LblPrompt.Text = "Position Fingers";
               if ((capMode & TpApiDevice.eCaptureMode.CMODE_AUTO_CAP) == 0)
                  this.LblPrompt.Text += ", then Press SCAN";
               this.LblPrompt.Left = ImageBox.Location.X + (ImageBox.Size.Width / 2) - (LblPrompt.Size.Width / 2);
               this.LblPrompt.Show();
            }
            this.Cursor = Cursors.Default;
         }
         else if (m_capState == TpApiDevice.eCaptureState.CSTATE_PREVIEW)
            m_Device.CaptureControl(TpApiDevice.eCapControl.CC_CAPTURE_IMAGE);
         else if (m_capState == TpApiDevice.eCaptureState.CSTATE_CAPTURED)
            m_Device.CaptureControl(TpApiDevice.eCapControl.CC_FINISH_IMAGE);
      }

      //--------------------------------------------------------------------------
      // StopCaptureButton_Click
      //--------------------------------------------------------------------------
      private void StopCaptureButton_Click(object sender, System.EventArgs e)
		{
         this.Cursor = aniCursor;
         m_Device.CaptureControl(TpApiDevice.eCapControl.CC_CANCEL_CAPTURE);
         EnableGUI(true);
         m_bCaptureInProgress = false;
         this.BtnStartCapture.Text = "CAPTURE";
         this.BtnStopCapture.Text = "ABORT";
         this.Cursor = Cursors.Default;
      }

      //--------------------------------------------------------------------------
      // CalPlaten_Click
      //--------------------------------------------------------------------------
      private void CalPlaten_Click(object sender, EventArgs e)
		{
         bool slap1Supported = false;
         bool slap4Supported = false;
         bool palmSupported = false;
         TpApiError r = m_Device.IsCalibrationSupported(
            TpApiDevice.eCaptureType.CTYPE_SLAP_ONE, ref slap1Supported);
         if (r == TpApiError.TPAPI_NOERROR)
         {
            if ((r = m_Device.IsCalibrationSupported(
                  TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR, ref slap4Supported)) == 
                  TpApiError.TPAPI_NOERROR)
            {
               if ((r = m_Device.IsCalibrationSupported(
                     TpApiDevice.eCaptureType.CTYPE_SLAP_PALM, ref palmSupported)) != 
                     TpApiError.TPAPI_NOERROR)
                  MessageBox.Show(r + " error retrieving palm calibration support",
                     "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else MessageBox.Show(r + " error retrieving SLAP4 calibration support",
               "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         else MessageBox.Show(r + " error retrieving SLAP1 calibration support",
            "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);

         if (r != TpApiError.TPAPI_NOERROR) return;

         if (!slap1Supported && !slap4Supported && !palmSupported)
         {
            MessageBox.Show("Platen Calibration is not supported on the attached device",
                "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            return;
         }

			if (MessageBox.Show("Thoroughly clean and cover the scanner platen.", "Calibrate Platen", 
				MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
			{
            this.Cursor = aniCursor;

               // Calibrate single finger (if supported)
            if (slap1Supported)
               r = m_Device.CalibrateScanner(TpApiDevice.eCaptureType.CTYPE_SLAP_ONE);
            if (r == TpApiError.TPAPI_NOERROR)
            {     // Calibrate four finger (if supported)
               if (slap4Supported)
                  r = m_Device.CalibrateScanner(TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR);
            }
            if (r == TpApiError.TPAPI_NOERROR)
            {     // Calibrate palm (if supported)
               if (palmSupported)
                  r = m_Device.CalibrateScanner(TpApiDevice.eCaptureType.CTYPE_SLAP_LPALM);
            }
            this.Cursor = Cursors.Default;
            
               // Display result
            if (r == TpApiError.TPAPI_NOERROR)
               MessageBox.Show("Calibration completed successfully!\n\nPress OK to continue.", 
                  "Calibrate Platen", MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
               MessageBox.Show("Platen Calibration Failed ("+r+")\n\nPlease re-calibrate.", 
                  "Calibration Error",MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}

      //--------------------------------------------------------------------------
      // CalHand_Click
      //--------------------------------------------------------------------------
      private void CalHand_Click(object sender, System.EventArgs e)
		{
         bool isSupported = false;
         TpApiError r = m_Device.IsCalibrationSupported(
            TpApiDevice.eCaptureType.CTYPE_HAND, ref isSupported);
         if (r != TpApiError.TPAPI_NOERROR)
         {
            MessageBox.Show("Hand Calibration Support error: " + r,
               "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         else if (!isSupported)
         {
            MessageBox.Show("Hand Calibration is not supported on the attached device",
               "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         else if (MessageBox.Show("After the first beep, roll the drum wheel slowly until " +
            "you hear the second beep.   ", "Calibrate Hand Scanner", 
				MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
			{
            this.Cursor = aniCursor;
            r = m_Device.CalibrateScanner(TpApiDevice.eCaptureType.CTYPE_HAND);
            this.Cursor = Cursors.Default;
            if (r != TpApiError.TPAPI_NOERROR)
				{
					if (r == TpApiError.TPAPI_BADRESPONSE)
						MessageBox.Show("The drum was rolled too fast (or too slow).\n\nPlease re-calibrate.", 
                     "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
					else
                  MessageBox.Show("Drum Calibration Failed ("+r+")\n\nPlease re-calibrate.", 
                     "Calibration Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
				}
				else
               MessageBox.Show("Calibration completed successfully!\n\nPress OK to continue.", 
                  "Calibrate Hand Scanner", MessageBoxButtons.OK, MessageBoxIcon.Information);
			}
      }

      //--------------------------------------------------------------------------
      // Selected Device Changed
      //--------------------------------------------------------------------------
      private void comboDevice_SelectedIndexChanged(object sender, EventArgs eArg)
      {
         this.Cursor = aniCursor;

         if (m_Device != null)
         {
            m_Device.CloseDevice();
            m_Connected = false;
         }
         this.LblStatus.Text = "         Initializing Device...";
         this.LblStatus.Update();

         m_Device = m_tpDevices[ComboDevSel.SelectedIndex];
         TpApiError r = m_Device.OpenDevice();
         if (r == TpApiError.TPAPI_NOERROR)
            m_Device.TP_ImgCallBk = new TpApiDevice.TpApi_CallBack(PreviewCallBack);
         else MessageBox.Show(r + " error opening device", "Open Error", 
            MessageBoxButtons.OK, MessageBoxIcon.Error);
         this.Cursor = Cursors.Default;
      }

      //--------------------------------------------------------------------------
      // Capture Options Changed
      //--------------------------------------------------------------------------
      private void AutoCap_CheckedChanged()
      {
         bool isSupported = false;
         if (m_Connected && 
            (m_Device.IsAutoCaptureSupported(m_capType, 
               ref isSupported) == TpApiError.TPAPI_NOERROR) && isSupported)
         {
            ChkAutoCap.Enabled = true;
            ChkAutoCap.Checked = m_bChkAutoCapChecked;
         }
         else
         {
            ChkAutoCap.Enabled = false;
            ChkAutoCap.Checked = false;
         }
      }

      private void NoRoll_CheckedChanged()
      {
         ChkRoll.Checked = false;
         ChkRoll.Enabled = false;
         AutoCap_CheckedChanged();
      }

      private void Roll_CheckedChanged()
      {
         ChkRoll.Checked = true;
         ChkRoll.Enabled = false;
         AutoCap_CheckedChanged();
      }

      private void SlapOrRoll_CheckedChanged()
      {
         ChkRoll.Enabled = true;
         AutoCap_CheckedChanged();
      }

      private void DFC_CheckedChanged(bool bEnable)
      {
         ChkRT.Visible = bEnable;
         ChkRI.Visible = bEnable;
         ChkRM.Visible = bEnable;
         ChkRR.Visible = bEnable;
         ChkRL.Visible = bEnable;
         ChkLT.Visible = bEnable;
         ChkLI.Visible = bEnable;
         ChkLM.Visible = bEnable;
         ChkLR.Visible = bEnable;
         ChkLL.Visible = bEnable;
         RadioL4.Visible = !bEnable;
         Radio2T.Visible = !bEnable;
         RadioR4.Visible = !bEnable;
         ChkRoll.Visible = !bEnable;
         RadioLH.Visible = !bEnable;
         RadioRH.Visible = !bEnable;
         RadioLP.Visible = !bEnable;
         RadioRP.Visible = !bEnable;
         RadioLI.Visible = !bEnable;
         RadioLM.Visible = !bEnable;
         RadioLR.Visible = !bEnable;
         RadioLL.Visible = !bEnable;
         RadioLT.Visible = !bEnable;
         RadioRI.Visible = !bEnable;
         RadioRM.Visible = !bEnable;
         RadioRR.Visible = !bEnable;
         RadioRL.Visible = !bEnable;
         RadioRT.Visible = !bEnable;
      }

      //--------------------------------------------------------------------------
      // Capture Type Changed
      //--------------------------------------------------------------------------
      private void RadioL4_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioL4.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_LFOUR;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_L4;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioR4_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioR4.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_RFOUR;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_R4;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void Radio2T_CheckedChanged(object sender, EventArgs e)
      {
         if (Radio2T.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_THUMBS;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_2T;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioLP_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLP.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_LPALM;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LP;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioRP_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRP.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_RPALM;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RP;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioLH_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLH.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_HAND;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LH;
            if (m_capTypeImg != null)
               PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioRH_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRH.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_HAND;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RH;
            if (m_capTypeImg != null)
               PicBoxCapType.Image = m_capTypeImg;
            NoRoll_CheckedChanged();
         }
      }

      private void RadioLI_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLI.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_LINDEX;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LI;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioLM_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLM.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_LMIDDLE;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LM;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioLR_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLR.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_LRING;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LR;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioLL_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLL.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_LLITTLE;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LL;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioRI_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRI.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_RINDEX;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RI;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioRM_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRM.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_RMIDDLE;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RM;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioRR_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRR.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_RRING;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RR;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioRL_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRL.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_ROLL_RLITTLE;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RL;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            Roll_CheckedChanged();
         }
      }

      private void RadioLT_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioLT.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_LTHUMB;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_LT;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            SlapOrRoll_CheckedChanged();
         }
      }

      private void RadioRT_CheckedChanged(object sender, EventArgs e)
      {
         if (RadioRT.Checked)
         {
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_RTHUMB;
            m_capTypeImg = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_RT;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
            SlapOrRoll_CheckedChanged();
         }
      }

      private void ChkDFC_CheckedChanged(object sender, EventArgs e)
      {
         if (ChkDFC.Checked)
         {
            DFC_CheckedChanged(true);
            m_capTypeSave = m_capType;
            m_capType = TpApiDevice.eCaptureType.CTYPE_SLAP_FOUR;
            System.Drawing.Image img = global::TPAPI_.NET_Sample_App.Properties.Resources.TP4100_GUI_Blank;
            if (img != null) PicBoxCapType.Image = img;
         }
         else
         {
            DFC_CheckedChanged(false);
            m_capType = m_capTypeSave;
            if (m_capTypeImg != null) PicBoxCapType.Image = m_capTypeImg;
         }
         AutoCap_CheckedChanged();
      }

      private void ChkAutoCap_CheckedChanged(object sender, EventArgs e)
      {
         if (ChkAutoCap.Enabled)
            m_bChkAutoCapChecked = this.ChkAutoCap.Checked;
      }

      //--------------------------------------------------------------------------
      /// <summary>
      /// A label that can be transparent.
      /// </summary>
      //--------------------------------------------------------------------------
      public class TransparentLabel : System.Windows.Forms.Control
      {
         /// <summary>
         /// Creates a new <see cref="TransparentLabel"/> instance.
         /// </summary>
         public TransparentLabel()
         {
            TabStop = false;
         }

         /// <summary>
         /// Gets the creation parameters.
         /// </summary>
         protected override CreateParams CreateParams
         {
            get
            {
               CreateParams cp = base.CreateParams;
               cp.ExStyle |= 0x20;
               return cp;
            }
         }

         /// <summary>
         /// Paints the background.
         /// </summary>
         /// <param name="e">Event args</param>
         protected override void OnPaintBackground(PaintEventArgs e)
         {
            // do nothing
         }

         /// <summary>
         /// Paints the control.
         /// </summary>
         /// <param name="e">Event args</param>
         protected override void OnPaint(PaintEventArgs e)
         {
            using (SolidBrush brush = new SolidBrush(Color.DarkBlue))
            {
               StringFormat stringFormat = new StringFormat();
               stringFormat.Alignment = StringAlignment.Center;
               e.Graphics.DrawString(Text, Font, brush, e.Graphics.VisibleClipBounds, stringFormat);
            }
         }
      }

      private void chkPollDev_CheckedChanged(object sender, EventArgs e)
      {
         if (chkPollDev.Checked)
            tmrChkDev.Start();
         else tmrChkDev.Stop();
      }
   }
}
